#ifndef __CProgressBar__
#define __CProgressBar__

//	===========================================================================

#include "CTextLabel.hpp"
using Exponent::GUI::Controls::CTextLabel;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @interface CProgressBar CProgressBar.hpp
			 * @brief A basic progress bar
			 *
			 * @date 19/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CProgressBar.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CProgressBar : public CTextLabel
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control
				 * @param uniqueId The unique panel id
				 * @param area The controls onscreen area 
				 */
				CProgressBar(IControlRoot *root, const long uniqueId, const CRect &area);

				/**
				 * Destruction
				 */
				virtual ~CProgressBar();

//	===========================================================================

				/**
				 * Set the vlaue of the control, treat as percentage to set the progress
				 * @param value The value between 0 - 1
				 */
				virtual void setValue(const double value);

//	===========================================================================

				/**
				 * Draw the controls
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

			protected:

//	===========================================================================

				CRect m_progressBarArea;			/**< The area covered by the progress */
			};
		}
	}
}
#endif	// End of CProgressBar.hpp